<?php
/**
 * Email Templates for POS System
 * Beautiful HTML email templates with CSS styling
 */

function getEmailHeader($storeName, $storeLogo = null) {
    $logoHtml = '';
    if ($storeLogo) {
        $logoHtml = '<img src="' . $storeLogo . '" alt="' . htmlspecialchars($storeName) . '" style="max-height: 60px; max-width: 200px; margin-bottom: 20px;">';
    }
    
    return '
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>' . htmlspecialchars($storeName) . '</title>
        <style>
            * {
                margin: 0;
                padding: 0;
                box-sizing: border-box;
            }
            
            body {
                font-family: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;
                line-height: 1.6;
                color: #333;
                background-color: #f8f9fa;
            }
            
            .email-container {
                max-width: 600px;
                margin: 0 auto;
                background-color: #ffffff;
                border-radius: 12px;
                overflow: hidden;
                box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            }
            
            .email-header {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                color: white;
                padding: 30px;
                text-align: center;
            }
            
            .email-header h1 {
                font-size: 24px;
                font-weight: 700;
                margin-bottom: 10px;
            }
            
            .email-header p {
                font-size: 14px;
                opacity: 0.9;
            }
            
            .email-body {
                padding: 30px;
            }
            
            .greeting {
                font-size: 18px;
                font-weight: 600;
                color: #2d3748;
                margin-bottom: 20px;
            }
            
            .message-content {
                font-size: 16px;
                color: #4a5568;
                margin-bottom: 25px;
                line-height: 1.7;
            }
            
            .items-section {
                background-color: #f7fafc;
                border-radius: 8px;
                padding: 20px;
                margin: 20px 0;
                border-left: 4px solid #4299e1;
            }
            
            .items-title {
                font-size: 16px;
                font-weight: 600;
                color: #2d3748;
                margin-bottom: 15px;
                display: flex;
                align-items: center;
            }
            
            .items-title i {
                margin-right: 8px;
                color: #4299e1;
            }
            
            .items-list {
                list-style: none;
                padding: 0;
            }
            
            .items-list li {
                background-color: white;
                padding: 12px 15px;
                margin-bottom: 8px;
                border-radius: 6px;
                border: 1px solid #e2e8f0;
                display: flex;
                justify-content: space-between;
                align-items: center;
            }
            
            .item-name {
                font-weight: 500;
                color: #2d3748;
            }
            
            .item-details {
                font-size: 14px;
                color: #718096;
            }
            
            .amount-section {
                background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
                color: white;
                padding: 20px;
                border-radius: 8px;
                margin: 20px 0;
                text-align: center;
            }
            
            .amount-label {
                font-size: 14px;
                opacity: 0.9;
                margin-bottom: 5px;
            }
            
            .amount-value {
                font-size: 24px;
                font-weight: 700;
            }
            
            .balance-section {
                background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
                color: white;
                padding: 20px;
                border-radius: 8px;
                margin: 20px 0;
                text-align: center;
            }
            
            .balance-label {
                font-size: 14px;
                opacity: 0.9;
                margin-bottom: 5px;
            }
            
            .balance-value {
                font-size: 24px;
                font-weight: 700;
            }
            
            .contact-section {
                background-color: #edf2f7;
                border-radius: 8px;
                padding: 20px;
                margin: 20px 0;
                text-align: center;
            }
            
            .contact-title {
                font-size: 16px;
                font-weight: 600;
                color: #2d3748;
                margin-bottom: 15px;
            }
            
            .contact-info {
                display: flex;
                justify-content: space-around;
                flex-wrap: wrap;
                gap: 15px;
            }
            
            .contact-item {
                text-align: center;
            }
            
            .contact-icon {
                font-size: 20px;
                color: #4299e1;
                margin-bottom: 5px;
            }
            
            .contact-text {
                font-size: 14px;
                color: #4a5568;
            }
            
            .cta-button {
                display: inline-block;
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                color: white;
                padding: 12px 30px;
                text-decoration: none;
                border-radius: 25px;
                font-weight: 600;
                margin: 10px 5px;
                transition: transform 0.2s;
                border: none;
                cursor: pointer;
                font-size: 14px;
            }
            
            .cta-button:hover {
                transform: translateY(-2px);
                color: white;
                text-decoration: none;
            }
            
            .pay-button {
                background: linear-gradient(135deg, #10b981 0%, #059669 100%);
                color: white;
                padding: 12px 30px;
                text-decoration: none;
                border-radius: 25px;
                font-weight: 600;
                margin: 10px 5px;
                transition: transform 0.2s;
                border: none;
                cursor: pointer;
                font-size: 14px;
                display: inline-block;
            }
            
            .pay-button:hover {
                transform: translateY(-2px);
                color: white;
                text-decoration: none;
                background: linear-gradient(135deg, #059669 0%, #047857 100%);
            }
            
            .button-container {
                text-align: center;
                margin: 20px 0;
            }
            
            /* Modal Styles */
            .modal {
                display: none;
                position: fixed;
                z-index: 1000;
                left: 0;
                top: 0;
                width: 100%;
                height: 100%;
                background-color: rgba(0,0,0,0.5);
                animation: fadeIn 0.3s;
            }
            
            .modal-content {
                background-color: #fefefe;
                margin: 10% auto;
                padding: 20px;
                border-radius: 12px;
                width: 90%;
                max-width: 400px;
                position: relative;
                animation: slideIn 0.3s;
            }
            
            .close {
                color: #aaa;
                float: right;
                font-size: 28px;
                font-weight: bold;
                cursor: pointer;
                line-height: 1;
            }
            
            .close:hover {
                color: #000;
            }
            
            .form-group {
                margin-bottom: 15px;
            }
            
            .form-label {
                display: block;
                margin-bottom: 5px;
                font-weight: 600;
                color: #2d3748;
            }
            
            .form-input {
                width: 100%;
                padding: 10px;
                border: 1px solid #e2e8f0;
                border-radius: 6px;
                font-size: 14px;
            }
            
            .form-input:focus {
                outline: none;
                border-color: #4299e1;
                box-shadow: 0 0 0 3px rgba(66, 153, 225, 0.1);
            }
            
            .btn {
                padding: 10px 20px;
                border: none;
                border-radius: 6px;
                font-weight: 600;
                cursor: pointer;
                font-size: 14px;
                margin: 5px;
            }
            
            .btn-primary {
                background-color: #4299e1;
                color: white;
            }
            
            .btn-primary:hover {
                background-color: #3182ce;
            }
            
            .btn-secondary {
                background-color: #e2e8f0;
                color: #4a5568;
            }
            
            .btn-secondary:hover {
                background-color: #cbd5e0;
            }
            
            @keyframes fadeIn {
                from { opacity: 0; }
                to { opacity: 1; }
            }
            
            @keyframes slideIn {
                from { transform: translateY(-50px); opacity: 0; }
                to { transform: translateY(0); opacity: 1; }
            }
            
            .email-footer {
                background-color: #2d3748;
                color: white;
                padding: 20px;
                text-align: center;
                font-size: 14px;
            }
            
            .footer-text {
                opacity: 0.8;
                margin-bottom: 10px;
            }
            
            .footer-links {
                margin-top: 15px;
            }
            
            .footer-links a {
                color: #4299e1;
                text-decoration: none;
                margin: 0 10px;
            }
            
            .footer-links a:hover {
                text-decoration: underline;
            }
            
            @media (max-width: 600px) {
                .email-container {
                    margin: 10px;
                    border-radius: 8px;
                }
                
                .email-header,
                .email-body {
                    padding: 20px;
                }
                
                .contact-info {
                    flex-direction: column;
                }
                
                .items-list li {
                    flex-direction: column;
                    align-items: flex-start;
                    gap: 5px;
                }
            }
        </style>
    </head>
    <body>
        <div class="email-container">
            <div class="email-header">
                ' . $logoHtml . '
                <h1>' . htmlspecialchars($storeName) . '</h1>
                <p>Professional Point of Sale System</p>
            </div>
            <div class="email-body">';
}

function getEmailFooter($storeName, $storePhone = '', $storeEmail = '', $storeWebsite = '') {
    $footer = '
            </div>
            <div class="email-footer">
                <div class="footer-text">
                    Thank you for choosing ' . htmlspecialchars($storeName) . '
                </div>
                <div class="footer-links">';
    
    if ($storePhone) {
        $footer .= '<a href="tel:' . htmlspecialchars($storePhone) . '">📞 Call Us</a>';
    }
    if ($storeEmail) {
        $footer .= '<a href="mailto:' . htmlspecialchars($storeEmail) . '">✉️ Email Us</a>';
    }
    if ($storeWebsite) {
        $footer .= '<a href="' . htmlspecialchars($storeWebsite) . '">🌐 Visit Website</a>';
    }
    
    $footer .= '
                </div>
            </div>
        </div>
    </body>
    </html>';
    
    return $footer;
}

function getMpesaPaymentModal($customerId, $customerName, $amount, $currency) {
    return '
    <!-- M-Pesa Payment Modal -->
    <div id="mpesaModal" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeMpesaModal()">&times;</span>
            <h3 style="margin-bottom: 20px; color: #2d3748;">💳 Pay with M-Pesa</h3>
            <form id="mpesaPaymentForm">
                <div class="form-group">
                    <label class="form-label">Customer Name</label>
                    <input type="text" class="form-input" value="' . htmlspecialchars($customerName) . '" readonly>
                </div>
                <div class="form-group">
                    <label class="form-label">Amount to Pay</label>
                    <input type="text" class="form-input" value="' . $currency . ' ' . number_format($amount, 2) . '" readonly>
                </div>
                <div class="form-group">
                    <label class="form-label">M-Pesa Phone Number</label>
                    <input type="tel" id="mpesaPhone" class="form-input" placeholder="254XXXXXXXXX" required>
                    <small style="color: #718096; font-size: 12px;">Enter your M-Pesa registered phone number</small>
                </div>
                <div style="text-align: center; margin-top: 20px;">
                    <button type="button" class="btn btn-secondary" onclick="closeMpesaModal()">Cancel</button>
                    <button type="submit" class="btn btn-primary" id="mpesaSubmitBtn">Send STK Push</button>
                </div>
            </form>
        </div>
    </div>
    
    <script>
        function openMpesaModal() {
            document.getElementById("mpesaModal").style.display = "block";
        }
        
        function closeMpesaModal() {
            document.getElementById("mpesaModal").style.display = "none";
        }
        
        // Close modal when clicking outside
        window.onclick = function(event) {
            var modal = document.getElementById("mpesaModal");
            if (event.target == modal) {
                modal.style.display = "none";
            }
        }
        
        // Handle M-Pesa payment form submission
        document.getElementById("mpesaPaymentForm").addEventListener("submit", function(e) {
            e.preventDefault();
            
            var phoneNumber = document.getElementById("mpesaPhone").value;
            var submitBtn = document.getElementById("mpesaSubmitBtn");
            
            // Validate phone number
            if (!phoneNumber || phoneNumber.length < 10) {
                alert("Please enter a valid phone number");
                return;
            }
            
            // Format phone number
            phoneNumber = phoneNumber.replace(/[^0-9]/g, "");
            if (phoneNumber.startsWith("0")) {
                phoneNumber = "254" + phoneNumber.substring(1);
            } else if (!phoneNumber.startsWith("254")) {
                phoneNumber = "254" + phoneNumber;
            }
            
            // Disable submit button
            submitBtn.disabled = true;
            submitBtn.textContent = "Processing...";
            
            // Get the base URL from the current location
            var baseUrl = window.location.protocol + "//" + window.location.host;
            
            // Send M-Pesa STK Push request
            fetch(baseUrl + "/api/mpesa_stkpush.php", {
                method: "POST",
                headers: {
                    "Content-Type": "application/json"
                },
                body: JSON.stringify({
                    phone: phoneNumber,
                    amount: ' . $amount . ',
                    customer_id: "' . $customerId . '",
                    customer_name: "' . htmlspecialchars($customerName) . '"
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert("✅ STK Push sent successfully! Please check your phone to complete the payment.");
                    closeMpesaModal();
                } else {
                    alert("❌ Error: " + (data.message || "Failed to send STK Push"));
                }
            })
            .catch(error => {
                console.error("M-Pesa Error:", error);
                alert("❌ Network error. Please try again.");
            })
            .finally(() => {
                submitBtn.disabled = false;
                submitBtn.textContent = "Send STK Push";
            });
        });
    </script>';
}

function createCreditReminderEmail($customerName, $invoiceNumber, $saleDate, $remainingBalance, $currency, $storeName, $storeAddress, $storePhone, $storeEmail = '', $storeWebsite = '', $items = [], $customerId = null) {
    $header = getEmailHeader($storeName);
    $footer = getEmailFooter($storeName, $storePhone, $storeEmail, $storeWebsite);
    
    // Format items list if provided
    $itemsList = '';
    if (!empty($items)) {
        foreach ($items as $item) {
            $itemsList .= '
                <li>
                    <span class="item-name">' . htmlspecialchars($item['name']) . '</span>
                    <span class="item-details">Qty: ' . $item['quantity'] . ' × ' . $currency . ' ' . number_format($item['price'], 2) . '</span>
                </li>';
        }
    }
    
    $emailContent = $header . '
        <div class="greeting">Dear ' . htmlspecialchars($customerName) . ',</div>
        
        <div class="message-content">
            This is a friendly reminder that you have a pending payment for your recent purchase.
        </div>
        
        <div class="amount-section">
            <div class="amount-label">Outstanding Balance</div>
            <div class="amount-value">' . $currency . ' ' . number_format($remainingBalance, 2) . '</div>
        </div>
        
        <div class="items-section">
            <div class="items-title">
                📄 Invoice Details
            </div>
            <ul class="items-list">
                <li>
                    <span class="item-name">Invoice Number</span>
                    <span class="item-details">#' . htmlspecialchars($invoiceNumber) . '</span>
                </li>
                <li>
                    <span class="item-name">Purchase Date</span>
                    <span class="item-details">' . date('F d, Y', strtotime($saleDate)) . '</span>
                </li>
            </ul>
        </div>';
    
    // Add items section if items are provided
    if (!empty($items)) {
        $emailContent .= '
        <div class="items-section">
            <div class="items-title">
                🛒 Items Purchased
            </div>
            <ul class="items-list">
                ' . $itemsList . '
            </ul>
        </div>';
    }
    
    $emailContent .= '
        <div class="contact-section">
            <div class="contact-title">How to Make Payment</div>
            <div class="contact-info">
                <div class="contact-item">
                    <div class="contact-icon">📍</div>
                    <div class="contact-text">Visit us at<br>' . htmlspecialchars($storeAddress) . '</div>
                </div>
                <div class="contact-item">
                    <div class="contact-icon">📞</div>
                    <div class="contact-text">Call us at<br>' . htmlspecialchars($storePhone) . '</div>
                </div>
            </div>
        </div>
        
        <div class="button-container">
            <a href="tel:' . htmlspecialchars($storePhone) . '" class="cta-button">Call to Arrange Payment</a>
            <a href="mailto:' . htmlspecialchars($storeEmail) . '" class="cta-button">Contact Us for Payment</a>
            <a href="https://' . $_SERVER['HTTP_HOST'] . '/pages/customer_payment.php?customer_id=' . $customerId . '&amount=' . $remainingBalance . '" class="pay-button" style="text-decoration: none; display: inline-block;">💳 Pay Now</a>
        </div>
        
        <div class="message-content">
            We appreciate your business and look forward to serving you again soon!
        </div>';
    
    // Note: JavaScript modals don't work in emails, so we use direct links instead
    
    return $emailContent . $footer;
}

function createCreditItemsAddedEmail($customerName, $items, $totalAmount, $totalBalance, $currency, $storeName, $storeAddress, $storePhone, $storeEmail = '', $storeWebsite = '', $customerId = null) {
    $header = getEmailHeader($storeName);
    $footer = getEmailFooter($storeName, $storePhone, $storeEmail, $storeWebsite);
    
    // Format items list
    $itemsList = '';
    foreach ($items as $item) {
        $itemsList .= '
                <li>
                    <span class="item-name">' . htmlspecialchars($item['name']) . '</span>
                    <span class="item-details">Qty: ' . $item['quantity'] . ' × ' . $currency . ' ' . number_format($item['price'], 2) . '</span>
                </li>';
    }
    
    $emailContent = $header . '
        <div class="greeting">Dear ' . htmlspecialchars($customerName) . ',</div>
        
        <div class="message-content">
            Your credit items have been successfully added to your account. Here are the details:
        </div>
        
        <div class="items-section">
            <div class="items-title">
                <i class="fas fa-shopping-cart"></i>
                Items Added
            </div>
            <ul class="items-list">
                ' . $itemsList . '
            </ul>
        </div>
        
        <div class="amount-section">
            <div class="amount-label">Total Amount</div>
            <div class="amount-value">' . $currency . ' ' . number_format($totalAmount, 2) . '</div>
        </div>
        
        <div class="balance-section">
            <div class="balance-label">Total Outstanding Balance</div>
            <div class="balance-value">' . $currency . ' ' . number_format($totalBalance, 2) . '</div>
        </div>
        
        <div class="contact-section">
            <div class="contact-title">Payment Options</div>
            <div class="contact-info">
                <div class="contact-item">
                    <div class="contact-icon">📍</div>
                    <div class="contact-text">Visit us at<br>' . htmlspecialchars($storeAddress) . '</div>
                </div>
                <div class="contact-item">
                    <div class="contact-icon">📞</div>
                    <div class="contact-text">Call us at<br>' . htmlspecialchars($storePhone) . '</div>
                </div>
            </div>
        </div>
        
        <div class="button-container">
            <a href="tel:' . htmlspecialchars($storePhone) . '" class="cta-button">Call to Arrange Payment</a>
            <a href="mailto:' . htmlspecialchars($storeEmail) . '" class="cta-button">Contact Us for Payment</a>
            <a href="https://' . $_SERVER['HTTP_HOST'] . '/pages/customer_payment.php?customer_id=' . $customerId . '&amount=' . $totalBalance . '" class="pay-button" style="text-decoration: none; display: inline-block;">💳 Pay Now</a>
        </div>
        
        <div class="message-content">
            Thank you for your business! We look forward to serving you again.
        </div>';
    
    // Note: JavaScript modals don't work in emails, so we use direct links instead
    
    return $emailContent . $footer;
}

function createPaymentReminderEmail($customerName, $unpaidItems, $totalBalance, $currency, $storeName, $storeAddress, $storePhone, $storeEmail = '', $storeWebsite = '', $customerId = null) {
    $header = getEmailHeader($storeName);
    $footer = getEmailFooter($storeName, $storePhone, $storeEmail, $storeWebsite);
    
    // Format unpaid invoices with their items
    $invoicesList = '';
    foreach ($unpaidItems as $item) {
        $invoicesList .= '
                <li>
                    <span class="item-name">' . htmlspecialchars($item['invoice']) . ' - ' . htmlspecialchars($item['date']) . '</span>
                    <span class="item-details">' . $currency . ' ' . number_format($item['balance'], 2) . '</span>
                </li>';
        
        // Add items for this invoice if available
        if (isset($item['items']) && !empty($item['items'])) {
            foreach ($item['items'] as $product) {
                $invoicesList .= '
                <li style="margin-left: 20px; background-color: #f8f9fa; border-left: 3px solid #4299e1;">
                    <span class="item-name">• ' . htmlspecialchars($product['name']) . '</span>
                    <span class="item-details">Qty: ' . $product['quantity'] . ' × ' . $currency . ' ' . number_format($product['price'], 2) . '</span>
                </li>';
            }
        }
    }
    
    $emailContent = $header . '
        <div class="greeting">Dear ' . htmlspecialchars($customerName) . ',</div>
        
        <div class="message-content">
            This is a friendly reminder about your outstanding payments. Please review the details below:
        </div>
        
        <div class="items-section">
            <div class="items-title">
                ⚠️ Unpaid Invoices
            </div>
            <ul class="items-list">
                ' . $invoicesList . '
            </ul>
        </div>
        
        <div class="balance-section">
            <div class="balance-label">Total Outstanding Balance</div>
            <div class="balance-value">' . $currency . ' ' . number_format($totalBalance, 2) . '</div>
        </div>
        
        <div class="contact-section">
            <div class="contact-title">Payment Options</div>
            <div class="contact-info">
                <div class="contact-item">
                    <div class="contact-icon">📍</div>
                    <div class="contact-text">Visit us at<br>' . htmlspecialchars($storeAddress) . '</div>
                </div>
                <div class="contact-item">
                    <div class="contact-icon">📞</div>
                    <div class="contact-text">Call us at<br>' . htmlspecialchars($storePhone) . '</div>
                </div>
            </div>
        </div>
        
        <div class="button-container">
            <a href="tel:' . htmlspecialchars($storePhone) . '" class="cta-button">Arrange Payment Now</a>
            <a href="mailto:' . htmlspecialchars($storeEmail) . '" class="cta-button">Contact Us for Payment</a>
            <a href="https://' . $_SERVER['HTTP_HOST'] . '/pages/customer_payment.php?customer_id=' . $customerId . '&amount=' . $totalBalance . '" class="pay-button" style="text-decoration: none; display: inline-block;">💳 Pay Now</a>
        </div>
        
        <div class="message-content">
            We appreciate your prompt attention to this matter. Thank you for your business!
        </div>';
    
    // Note: JavaScript modals don't work in emails, so we use direct links instead
    
    return $emailContent . $footer;
}
?> 